#Proyecto 4.2. Limpiar la cruz roja

Un dibujo de la cruz roja hecho con bolitas se manchó con ceniza; el propósito del programa 
que hay que hacer es limpiar la imagen de ceniza, sacando las bolitas negras. 
Construí ese programa. El tablero inicial y el tablero final se dan a continuación.

<center>
![Tableros inicial y final](data:image/png;base64,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)
</center>

Fijate que el tablero inicial va a ser siempre el mismo, con lo cual tenés que encontrar qué 
comandos precisás y en qué orden. 
¿Qué pasa si te equivocás en el orden de los comandos? 
Es complicado resolver este problema usando solamente los comandos `Mover` y `Sacar`, ¿no? 

> **El que busca, encuentra**
>
> ¿Habrá más de un programa que funcione para este problema? 
> Para probar, tratá de guardar el programa que hiciste en la computadora y hacer otro distinto. 
> Para guardar el programa, usá el ícono al lado del de seleccionar proyecto. 
> ¡Acordate de ponerle un nombre distinto a cada solución!
> <center>
> ![Botón de guardar proyecto](data:image/png;base64,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)

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/1.Descubrir%20Gobstones/4.2.Limpiar%20la%20cruz%20roja/assets/resources/description.pdf "Enunciado de 'Limpiar la cruz roja' en PDF"

